/*------------------------------------------------------------------
			Debug Library
			-------------

	Header for C++ interface to debug library

	(C) Silicon Dream Ltd 1994

  ------------------------------------------------------------------

Changes:						Date:
* Created file						27/10/94
*/

#ifndef CPPDEBUG
#define CPPDEBUG

/* Defined operations:

	New class[...]		Modified new operator for allocating objects
	Delete [] pclass	Modified delete operator for destroying objects
*/

extern "C"
{
#include <debug.h>
}

#ifdef _DEBUG
/* Overload new operator to call debug allocation routine */

_st inline void *operator new (size_t st, char *szFN, ushort usLine, ushort us)
	{
	return DebAlloc((ulong) st, szFN, usLine, TRUE, DebAppAlloc);
	us;	// This parameter is used only so as we don't clash with
		// MFC's overloaded debug new operator
	}

/* Overload delete operator to call debug free routine */

_st inline void operator delete (void *pv)
	{
	Free(pv);
	return;
	}
#define New	::new(__FILE__, __LINE__, 0)
#define Delete	::delete
#endif

#ifndef _DEBUG
#define New	new
#define Delete	delete
#endif

#endif			// Do not include this file twice
